// Source based on ”Raymarched plasma" by Himred
// Published on SharderToy https://www.shadertoy.com/view/ldSfzm
// License: Public Domain

uniform float u_Elapsed;		// This is the time elapsed in seconds since the beginning of the scene.
uniform vec2 u_WindowSize;		// This is the dimensions of the viewport.
//uniform float u_delta = mod(u_Elapsed,128.);

float m(vec3 p)
{
    p.y+=5.*u_Elapsed*0.15;
    return length(.2*sin(p.x-p.y)+cos(p/3.))-.8;
    //return length(.2*sin(p.x-p.y)+cos(p/3.)-.1*sin(1.5*p.x))-.8;
    
}

void main( void )
{    
// gl_FragCoord.xy
// u_WindowSize.xy;
// u_Elapsed
// gl_FragColor
    
    vec2 u=gl_FragCoord.xy;
    vec3 d=.5-vec3(u,0)/u_WindowSize.x,o=d;

    for(int i=0;i<80;i++) o+=m(o)*d;
//    gl_FragColor.xyz = abs(m(o+d)*vec3(.3,.15,.1)+m(o*.5)*vec3(.1,.05,0))*(8.-o.x/2.);
    gl_FragColor.xyz = abs(m(o+d)*vec3(.3,.15,.1)+m(o*.5)*vec3(.1,.05,0))*(8.-o.x/2.);
   
    gl_FragColor.a = 1.0;

}